/*
 * Decompiled with CFR 0.152.
 */
package jclass.chart;

import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageFilter;
import jclass.bwt.JCSerializable;
import jclass.chart.ChartCanvas;
import jclass.chart.ChartRegion;
import jclass.chart.RotateFilter;
import jclass.util.JCString;
import jclass.util.JCUtilConverter;

public class ChartText
extends ChartRegion
implements JCSerializable {
    int adjust = 1;
    int rotation;
    String text;
    boolean jcstring = false;
    JCString realContents;
    transient Image buffer;
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    public static final int DEG_0 = 0;
    public static final int DEG_90 = 1;
    public static final int DEG_180 = 2;
    public static final int DEG_270 = 3;

    public ChartText() {
    }

    public void draw(Graphics graphics) {
        if (!this.isShowing) {
            return;
        }
        if (this.parent == null) {
            return;
        }
        super.draw(graphics);
        if (this.rotation == 0) {
            int n = this.borderStyle == null ? 0 : this.borderStyle.width;
            super.draw(graphics);
            Rectangle rectangle = new Rectangle(this.getLeft() + n, this.getTop() + n, this.getWidth() - 2 * n, this.getHeight() - 2 * n);
            graphics.setColor(this.getForeground());
            graphics.setFont(this.getFont());
            if (this.realContents != null) {
                try {
                    switch (this.adjust) {
                        case 0: {
                            this.realContents.draw(this.parent, graphics, rectangle, 0);
                            return;
                        }
                        case 2: {
                            this.realContents.draw(this.parent, graphics, rectangle, 2);
                            return;
                        }
                    }
                    this.realContents.draw(this.parent, graphics, rectangle, 1);
                    return;
                }
                catch (Exception exception) {
                    exception.printStackTrace(System.out);
                    return;
                }
            }
            FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(this.getFont());
            if (this.text != null) {
                graphics.drawString(this.text, rectangle.x, rectangle.y + rectangle.height - (this.getHeight() - fontMetrics.getAscent()));
                return;
            }
        } else if (this.buffer != null) {
            graphics.drawImage(this.buffer, this.getLeft(), this.getTop(), this.parent);
        }
    }

    public synchronized void setRotation(int n) {
        if (n == this.rotation) {
            return;
        }
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                this.rotation = n;
                this.setChanged(true);
                return;
            }
        }
        throw new IllegalArgumentException("Invalid value for Rotation in ChartText.  Must be one of DEG_90, DEG_180, DEG_270 or DEG_0");
    }

    public int getRotation() {
        return this.rotation;
    }

    public int getAdjust() {
        return this.adjust;
    }

    public synchronized void setAdjust(int n) {
        if (n == this.adjust) {
            return;
        }
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                this.adjust = n;
                this.setChanged(true);
                return;
            }
        }
        throw new IllegalArgumentException("Invalid Adjust in ChartText.  Must be one of LEFT, CENTER or RIGHT");
    }

    public String getText() {
        return this.text;
    }

    public synchronized void setText(String string) {
        this.setText(string, false);
    }

    JCString getRealContents() {
        return this.realContents;
    }

    public synchronized void setText(String string, boolean bl) {
        this.text = string;
        this.realContents = null;
        this.jcstring = bl;
        this.isShowing = true;
        if (this.parent == null) {
            return;
        }
        this.makeRealContents();
        this.setChanged(true);
    }

    public ChartText(ChartCanvas chartCanvas, String string, boolean bl) {
        this.setText(string, bl);
        this.setParent(chartCanvas);
    }

    public ChartText(ChartCanvas chartCanvas, JCString jCString) {
        super(chartCanvas);
        this.realContents = jCString;
    }

    public void recalc() {
        if (!this.isChanged()) {
            return;
        }
        if (this.parent != null && this.parent.getPeer() == null) {
            return;
        }
        if (this.rotation == 0) {
            Dimension dimension = this.calcSize();
            int n = this.borderStyle == null ? 0 : this.borderStyle.width;
            this.resize(dimension.width + 2 * n, dimension.height + 2 * n);
        } else {
            this.createContentImage();
            this.resize(this.buffer.getWidth(this.parent), this.buffer.getHeight(this.parent));
        }
        this.setChanged(false);
    }

    private void createContentImage() {
        try {
            Object object;
            Dimension dimension = this.calcSize();
            int n = this.borderStyle == null ? 0 : this.borderStyle.width;
            this.buffer = this.parent.createImage(dimension.width + n * 2, dimension.height + n * 2);
            Graphics graphics = this.buffer.getGraphics();
            graphics.setColor(this.getBackground());
            graphics.setFont(this.getFont());
            graphics.fillRect(0, 0, dimension.width + n * 2, dimension.height + n * 2);
            super.draw(graphics);
            Rectangle rectangle = new Rectangle(n, n, dimension.width, dimension.height);
            graphics.setColor(this.getForeground());
            if (this.realContents == null) {
                object = Toolkit.getDefaultToolkit().getFontMetrics(this.getFont());
                if (this.text != null) {
                    graphics.drawString(this.text, rectangle.x, rectangle.y + rectangle.height - (dimension.height - ((FontMetrics)object).getAscent()));
                }
            } else {
                try {
                    switch (this.adjust) {
                        case 0: {
                            this.realContents.draw(this.parent, graphics, rectangle, 0);
                            break;
                        }
                        case 2: {
                            this.realContents.draw(this.parent, graphics, rectangle, 2);
                            break;
                        }
                        default: {
                            this.realContents.draw(this.parent, graphics, rectangle, 1);
                            break;
                        }
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace(System.out);
                }
            }
            if (this.rotation != 0) {
                object = new RotateFilter(this.rotation);
                FilteredImageSource filteredImageSource = new FilteredImageSource(this.buffer.getSource(), (ImageFilter)object);
                Image image = this.parent.createImage(filteredImageSource);
                JCUtilConverter.waitForImage(this.parent, image);
                this.buffer.flush();
                this.buffer = image;
                return;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.setChanged(true);
        }
    }

    public synchronized void setParent(ChartCanvas chartCanvas) {
        super.setParent(chartCanvas);
        this.makeRealContents();
        this.setChanged(true, false);
        this.recalc();
    }

    private void makeRealContents() {
        if (this.text == null) {
            return;
        }
        this.realContents = null;
        if (this.jcstring && this.parent != null) {
            this.realContents = JCString.parse(this.parent, this.text);
        }
    }

    Dimension calcSize() {
        if (this.realContents == null) {
            if (this.getFont() == null) {
                return new Dimension(0, 0);
            }
            FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(this.getFont());
            if (this.text == null) {
                return new Dimension(0, fontMetrics.getHeight());
            }
            return new Dimension(fontMetrics.stringWidth(this.text), fontMetrics.getHeight());
        }
        return this.realContents.getSize(this.parent, this.getFont());
    }
}

